from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class Hopeless(Player):
    """A player that only defects after mutual cooperation.

    Names:

    - Hopeless: [Berg2015]_"""

    name = "Hopeless"
    classifier = {
        "memory_depth": 1,
        "long_run_time": False,
        "stochastic": True,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        if not opponent.history:
            return self._random.random_choice()
        if self.history[-1] == C and opponent.history[-1] == C:
            return D
        return C